//

// Fragment shader for simplistic tiling
//
// Author: Jeff Brown
//

uniform sampler2DRect texUnit;
uniform sampler2DRect inTexUnit;
uniform sampler2DRect outTexUnit;

uniform vec4 textureRect;

uniform int hasTextureIn;  // 0 = no texture in, 1 = has texture in 
uniform int hasTextureOut;  // 0 = no texture in, 1 = has texture in 

uniform float numHorizontalTiles;
uniform float numVerticalTiles;
uniform float gridSize;

varying vec2 gUV;
//varying vec2 gUV2;

void main(void)
{
	if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else
    {
        float textureWidth = textureRect.z;
        float textureHeight = textureRect.w;
        
        vec2 xy;
        if(gridSize!=0.)
        {
            xy.x=gUV.x*numHorizontalTiles;
            float tmp=xy.x/textureWidth;
            tmp=fract(tmp);
            float pos=3.1415926535*tmp;
            float dim1=sqrt(min(1.0,sin(pos)*(22.0-gridSize)));
            xy.x=tmp*textureWidth;
            xy.y=gUV.y*numVerticalTiles;
            tmp=xy.y/textureHeight;
            tmp=fract(tmp);
            pos=3.1415926535*tmp;
            float dim2=sqrt(min(1.0,sin(pos)*(22.0-gridSize)));
            xy.y=tmp*textureHeight;
            gl_FragColor = texture2DRect(texUnit,xy)*dim1*dim2;
        }
        else
        {
            xy.x=gUV.x*numHorizontalTiles;
            float tmp=xy.x/textureWidth;
            tmp=fract(tmp);
            xy.x=tmp*textureWidth;
            xy.y=gUV.y*numVerticalTiles;
            tmp=xy.y/textureHeight;
            tmp=fract(tmp);
            xy.y=tmp*textureHeight;
            gl_FragColor = texture2DRect(texUnit,xy);
        }
    }
}
